<?php
/**
 * Shop shortcodes.
 *
 * @package WordPress
 * @subpackage labomba
 * @category Core
 * @author Dahz
 * @since 1.0.0
 *
 * TABLE OF CONTENTS
 *
 * 1. Credit Card
 * 2. Recently Viewed
 * 3. The Look
 * 4. Product Slider
 * 5  Product Pagination
 */
/**
 *  1. Credit Card
 *
 *    Show the icons for the credit cards
 *
 * @example
 *   [credit cards="paypal,visa,mastercard,amex,cirrus,maestro,solo,discover,delta,visa-electron,bank-check"]
**/
function df_credit_card_sc($atts, $content = null)
{
    extract(shortcode_atts(array(
        'cards' => 'paypal,visa,mastercard,amex,cirrus,maestro,solo,discover,delta,visa-electron,bank-check'
    ), $atts));

    $cards = explode( ',', $cards );

    $html = '';
    foreach ( $cards as $card ) {
        $card = trim($card);
        $html .= "<img src=\"" . get_template_directory_uri() . "/images/credit-cards/$card.png\" alt=\"$card\" style=\"margin-right:8px\" />";
    }

    return  '<span class="df-wc-cc">' . $html . '</span>' ;
}


/**
 *  2. Recently Viewed
 *
 *    Show Recently Viewed Products
 *
 * @example
 *   [woocommerce_recently_viewed_products per_page="5"]
**/
function df_recently_viewed_products_sc( $atts, $content = null ) {

    // Get shortcode parameters
    extract(shortcode_atts(array(
        "per_page" => '5'
    ), $atts));

    // Get WooCommerce Global
    global $woocommerce;

    // Get recently viewed product cookies data
    $viewed_products = ! empty( $_COOKIE['woocommerce_recently_viewed'] ) ? (array) explode( '|', $_COOKIE['woocommerce_recently_viewed'] ) : array();
    $viewed_products = array_filter( array_map( 'absint', $viewed_products ) );

    // If no data, quit
    if ( empty( $viewed_products ) )
        return __( 'You have not viewed any product yet!', 'woothemes' );

    // Create the object
    ob_start();

    // Get products per page
    if( !isset( $per_page ) ? $number = 5 : $number = $per_page )

    // Create query arguments array
    $query_args = array(
                    'posts_per_page' => $number,
                    'no_found_rows'  => 1,
                    'post_status'    => 'publish',
                    'post_type'      => 'product',
                    'post__in'       => $viewed_products,
                    'orderby'        => 'rand'
                    );

    // Add meta_query to query args
    $query_args['meta_query'] = array();

    // Check products stock status
    $query_args['meta_query'][] = WC()->query->stock_status_meta_query();
    $query_args['meta_query'] = array_filter( $query_args['meta_query'] );

    // Create a new query
    $r = new WP_Query($query_args);
    // If query return results
    if ( $r->have_posts() ) {

        $content = '<ul class="products">';

        // Start the loop
        while ( $r->have_posts()) {
            $r->the_post();
            global $product;

            $content .= '<li class="product">
                <a href="' . get_permalink() . '">
                    ' .( has_post_thumbnail() ? get_the_post_thumbnail( $r->post->ID, 'shop_catalog' ) : woocommerce_placeholder_img( 'shop_catalog' ) ) . '<h3>' . get_the_title() . '
               </h3> </a> </li>';
        }

        $content .= '</ul>';

    }

    // Get clean object
    $content .= ob_get_clean();

    // Return whole content
    return $content;
}



    /**
     * 3. The Look
     *
     * @access public
     * @param array $atts
     * @return string
     */
    function df_woocommerce_product_page_sc( $atts ) {

        if ( empty( $atts ) ) return;

        if ( ! isset( $atts['id'] ) && ! isset( $atts['sku'] ) ) return;

        $args = array(
            'posts_per_page'    => 1,
            'post_type' => 'product',
            'post_status' => 'publish',
            'ignore_sticky_posts'   => 1,
            'no_found_rows' => 1
        );

        if ( isset( $atts['sku'] ) ) {
            $args['meta_query'][] = array(
                'key'     => '_sku',
                'value'   => $atts['sku'],
                'compare' => '='
            );
        }

        if ( isset( $atts['id'] ) ) {
            $args['p'] = $atts['id'];
        }

        $single_product = new WP_Query( $args );

        ob_start();

        while ( $single_product->have_posts() ) : $single_product->the_post(); wp_enqueue_script( 'wc-single-product' ); ?>

      <?php global $post, $product, $woocommerce; ?>
            <div class="single-product-sc" style="overflow:hidden;">

                <div itemscope itemtype="http://schema.org/Product" id="product-<?php the_ID(); ?>" <?php post_class(); ?>>
<?php woocommerce_get_template( 'single-product/sale-flash.php' ); ?>
<div class="images">
    <?php if ( has_post_thumbnail() ) : ?>
            <a href="<?php echo get_permalink($product->ID); ?>" class="woocommerce-main-image">
                    <?php echo get_the_post_thumbnail( $post->ID, apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ) ); ?>
             </a>
       <?php  endif;  ?>
       <a href="<?php echo get_permalink($product->ID); ?>" ><?php _e('View Details', 'woocommerce'); ?></a>
</div>

    <div class="summary entry-summary">
            <div class="woocommerce-summary-wrap">
                <h1 itemprop="name" class="product_title entry-title"><?php the_title(); ?></h1>
                            <div class="clear"></div>
                             <div itemprop="description">
                                     <?php echo labomba_word_trim($post->post_excerpt, 20, '...'); ?>
                            </div>
     </div>
     <div class="woocommerce-qty-wrap">
                <div itemprop="offers" itemscope itemtype="http://schema.org/Offer">
                        <p itemprop="price" class="price"><?php echo $product->get_price_html(); ?></p>
                         <meta itemprop="priceCurrency" content="<?php echo get_woocommerce_currency(); ?>" />
                </div>


      <?php do_action ('custom_single_product_summary'); ?>

      <?php if( class_exists( 'YITH_WCWL' ) ) { echo do_shortcode( '[yith_wcwl_add_to_wishlist]' ); } ?>
      </div>

    </div><!-- .summary -->

</div><!-- #product-<?php the_ID(); ?> -->

            </div>


        <?php endwhile; // end of the loop.

        wp_reset_postdata();

        return '<div class="woocommerce" style="overflow:hidden;">' . ob_get_clean() . '</div>';
    }



/**
 *  4. Product Slider
 *
 *    Show Recently Viewed Products
 *
 * @example
 *   [product_slider]
**/

function df_woocommerce_product_carousel_sc($atts, $content = null) {

        global $woocommerce, $woocommerce_loop;

        if (empty($atts)) return;

          extract(shortcode_atts(array(
        "product_type" => "best-sellers",
        "carousel" => "no",
       "widths" => "1/1",
        "item_perpage" => "",
             ), $atts));

        $args = array();

        // ARRAY ARGUMENTS
        if ($product_type == "latest-products") {
            $args = array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'ignore_sticky_posts'   => 1,
                    'posts_per_page' => $item_perpage
                );
        } else if ($product_type == "featured-products") {
            $args = array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'ignore_sticky_posts'   => 1,
                    'meta_key' => '_featured',
                    'meta_value' => 'yes',
                    'posts_per_page' => $item_perpage
                );
        } else if ($product_type == "top-rated") {
            add_filter( 'posts_clauses',  array( $woocommerce->query, 'order_by_rating_post_clauses' ) );

            $args = array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'ignore_sticky_posts'   => 1,
                    'posts_per_page' => $item_perpage
                );
            $args['meta_query'] = $woocommerce->query->get_meta_query();

        } else if ($product_type == "recently-viewed") {

            // Get recently viewed product cookies data
            $viewed_products = ! empty( $_COOKIE['woocommerce_recently_viewed'] ) ? (array) explode( '|', $_COOKIE['woocommerce_recently_viewed'] ) : array();
            $viewed_products = array_filter( array_map( 'absint', $viewed_products ) );

            // If no data, quit
            if ( empty( $viewed_products ) )
                return '<p class="no-products">'.__( "You haven't viewed any products yet.", "woothemes").'</p>';

            // Create query arguments array
            $args = array(
                    'post_type'      => 'product',
                    'post_status'    => 'publish',
                    'ignore_sticky_posts'   => 1,
                    'posts_per_page' => $item_perpage,
                    'no_found_rows'  => 1,
                    'post__in'       => $viewed_products,
                    'orderby'        => 'rand'
                );

        } else if ($product_type == "sale-products") {

            $product_ids_on_sale = woocommerce_get_product_ids_on_sale();

        $meta_query = array();
        $meta_query[] = $woocommerce->query->visibility_meta_query();
        $meta_query[] = $woocommerce->query->stock_status_meta_query();
        $meta_query   = array_filter( $meta_query );

            $args = array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'ignore_sticky_posts'   => 1,
                    'posts_per_page' => $item_perpage,
                    'meta_query' => $meta_query,
                    'post__in'     => array_merge( array( 0 ), $product_ids_on_sale )
                );
        } else if ($product_type == "sku-id") {
            $args = array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'ignore_sticky_posts'   => 1,
                //'orderby' => $orderby,
                //'order' => $order,
                'posts_per_page' => $item_perpage,
                'meta_query' => array(
                    array(
                        'key'       => '_visibility',
                        'value'     => array('catalog', 'visible'),
                        'compare'   => 'IN'
                    )
                )
            );

                if(isset($atts['skus'])){
                    $skus = explode(',', $atts['skus']);
                    $skus = array_map('trim', $skus);
                    $args['meta_query'][] = array(
                        'key'       => '_sku',
                        'value'     => $skus,
                        'compare'   => 'IN'
                    );
                }

                if(isset($atts['ids'])){
                    $ids = explode(',', $atts['ids']);
                    $ids = array_map('trim', $ids);
                    $args['post__in'] = $ids;
                }

        } else {
            $args = array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'ignore_sticky_posts'   => 1,
                    'posts_per_page' => $item_perpage,
                    'meta_key'      => 'total_sales',
                    'orderby'       => 'meta_value'
                );
        }

        ob_start();

        // OUTPUT PRODUCTS
        $products = new WP_Query( $args );

        $single_layout = get_post_meta( get_the_ID(), 'layout', true );
        $number = 4;
        if($single_layout == 'one-col' ){
        if ($widths == "2/3") {
                $woocommerce_loop['columns'] = 3;
                $number = 3;

            } else if ($widths == "1/2") {
                $woocommerce_loop['columns'] = 2;
                 $number = 2;

            } else if ($widths == "1/4") {
                $woocommerce_loop['columns'] = 1;
                 $number = 1;

            } else {
                    $woocommerce_loop['columns'] = 4;
                }

        } elseif ($single_layout == 'two-col-left' || $single_layout == 'two-col-right') {

        $woocommerce_loop['columns'] = 3;
        $number = 3;

        } else {

            if ($widths == "2/3") {
                $woocommerce_loop['columns'] = 3;
                $number = 3;

            } else if ($widths == "1/2") {
                $woocommerce_loop['columns'] = 2;
                 $number = 2;

            } else if ($widths == "1/4") {
                $woocommerce_loop['columns'] = 1;
                 $number = 1;

            } else {
                    $woocommerce_loop['columns'] = 4;
                }

        }

        $id = mt_rand( 99, 9999 );
       // $widths = wpb_translateColumnWidthToSpan($widths);

        if ( $products->have_posts() ) { ?>

            <?php if ($carousel == "yes") { ?>

                <?php
                wp_enqueue_script('owlcarousel');
                ?>

            <script>
           jQuery(function($){
             var owl = $("#carousel-product-<?php echo $id; ?>");

 $(document).ready(function(){
       owl.owlCarousel({
      items : <?php echo $number; ?>,
      dots:false,
      responsive:{
        0:{
            items:1
        },
        481:{
            items:2
        },
        767:{
            items:2
        },
        959:{
            items:<?php echo $number; ?>
        }
      }
  });
             // Custom Navigation Events
  $(".next-<?php echo $id ?>").click(function(){
    owl.trigger('next.owl.carousel');
  })
  $(".prev-<?php echo $id ?>").click(function(){
    owl.trigger('prev.owl.carousel');
  })

});
             });
            </script>

                <div class="product-slider-sc woocommerce-columns-<?php echo $number; ?>">

                   <div style="overflow:hidden;">

                        <ul id="carousel-product-<?php echo $id; ?>" class="products list-<?php echo $product_type; ?>">

                            <?php while ( $products->have_posts() ) : $products->the_post(); ?>

                                <?php woocommerce_get_template_part( 'content', 'product' ); ?>

                            <?php endwhile; // end of the loop. ?>

                        </ul>

                    </div>
                    <a class="prev prev-<?php echo $id ?>"><i class="fa fa-chevron-left"></i></a><a class="next next-<?php echo $id ?>"><i class="fa fa-chevron-right"></i></a>

                  </div>

            <?php } else {  ?>
        <div class="woocommerce woocommerce-columns-<?php echo $number; ?>">
            <ul class="products list-<?php echo $product_type; ?>">

                <?php while ( $products->have_posts() ) : $products->the_post(); ?>

                    <?php woocommerce_get_template_part( 'content', 'product' ); ?>

                <?php endwhile; // end of the loop. ?>

            </ul>
        </div>
            <?php } ?>

        <?php }

       $product_list_output = ob_get_contents();
       ob_end_clean();

       wp_reset_query();
       wp_reset_postdata();
       remove_filter( 'posts_clauses',  array( WC()->query, 'order_by_rating_post_clauses' ) );

       return $product_list_output;

    }


 //Register The Shortcode

 add_shortcode('credit', 'df_credit_card_sc');
 add_shortcode('woocommerce_recently_viewed_products', 'df_recently_viewed_products_sc');
 add_shortcode('the_look', 'df_woocommerce_product_page_sc');
 add_shortcode('product_slider', 'df_woocommerce_product_carousel_sc' );
