<?php
// don't load directly
if ( !defined( 'ABSPATH' ) ) { die( '-1' ); }

/**
 * Table Of Content
 *
 * - Set Several variables
 * 		- categories
 *		- button & link target
 * 		- declare icon types
 * - Set new shortcode map
 *		- Banner content
 *		- Service
 *		- Service List
 *		- Social Icon
 *		- Teaser
 *		- Teaser Box
 *		- CallOut Action
 *		- Box Content
 * 		- Blog Grid
 *		- Blog List
 *		- Testimonial
 *		- Highlight
 *		- Blockquote
 *		- Table
 * 		- Portfolio
 *		- Parallax
 *		- Advance Gmaps
 *		- WooCommerce
 *			- Credit card
 *			- Shop carousel
 */


/**
 * Set several variables
 */

/* categories */
$link_category 	= array( __( "All", "woothemes" ) => "" );
$link_cats 		= get_terms( "category" );

if ( is_array( $link_cats ) ) {
	foreach ( $link_cats as $link_cat ) {
		$link_category[$link_cat->slug] = $link_cat->slug;
	}
}

/* button & link target */
$button_style 	= array( "", "red", "orange", "green", "aqua", "teal", "purple", "pink", "silver", "brown", "gold", "Alternative 1" => "alt-1", "Alternative 2" => "alt-2" );
$target_arr 	= array( __("Same window", "woothemes") => "_self", __("New window", "woothemes") => "_blank");

$add_css_animation = array(
	"type" 			=> "dropdown",
	"heading" 		=> __("CSS Animation", "woothemes"),
	"param_name" 	=> "css_animation",
	"admin_label" 	=> true,
	"value" 		=> array(
	                   		__("No", "woothemes") 					=> "",
	                   		__("Top to bottom", "woothemes") 		=> "top-to-bottom",
	                   		__("Bottom to top", "woothemes") 		=> "bottom-to-top",
	                   		__("Left to right", "woothemes") 		=> "left-to-right",
	                   		__("Right to left", "woothemes") 		=> "right-to-left",
	                   		__("Appear from center", "woothemes") 	=> "appear"
	                   ),
	"description" 	=> __("Select animation type if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "woothemes")
);

/* declare icon types */
$type_icon = array(
	'Twitter' 		=> 'ico-twitter',
	'Behance' 		=> 'ico-behance',
	'Digg' 			=> 'ico-digg',
	'Dribble' 		=> 'ico-dribble',
	'Evernote' 		=> 'ico-evernote',
	'Facebook' 		=> 'ico-facebook',
	'GooglePlus' 	=> 'ico-google-plus',
	'Digg' 			=> 'ico-digg',
	'Blogger' 		=> 'ico-blogger',
	'Dribble' 		=> 'ico-dribble',
	'Flickr' 		=> 'ico-flickr',
	'Foursquare' 	=> 'ico-foursquare',
	'Linkedin' 		=> 'ico-linkedin',
	'Myspace' 		=> 'ico-myspace',
	'Path' 			=> 'ico-path',
	'Amazon' 		=> 'ico-amazon',
	'Apple' 		=> 'ico-apple',
	'Dropbox' 		=> 'ico-dropbox',
	'Ebay' 			=> 'ico-ebay',
	'Ember' 		=> 'ico-ember',
	'Etsy' 			=> 'ico-etsy',
	'Feedburner' 	=> 'ico-feedburner',
	'Forrst' 		=> 'ico-forrst',
	'Github' 		=> 'ico-github',
	'Google' 		=> 'ico-google',
	'Last' 			=> 'ico-last',
	'Paypal' 		=> 'ico-paypal',
	'Picasa' 		=> 'ico-picasa',
	'Reddit' 		=> 'ico-reddit',
	'Rss' 			=> 'ico-rss',
	'Sharethis' 	=> 'ico-sharethis',
	'Skype' 		=> 'ico-skype',
	'Soundcloud' 	=> 'ico-soundcloud',
	'Spotify' 		=> 'ico-spotify',
	'Tumblr' 		=> 'ico-tumblr',
	'Vimeo' 		=> 'ico-vimeo',
	'Yahoo' 		=> 'ico-yahoo',
	'Youtube' 		=> 'ico-youtube',
	'Wordpress' 	=> 'ico-wordpress',
	'Xing' 			=> 'ico-xing',
	'Instagram' 	=> 'ico-instagram',
	'Stackex' 		=> 'ico-stackex',
	'Android' 		=> 'ico-android',
	'Delicious' 	=> 'ico-delicious',
	'Technorati' 	=> 'ico-technorati',
	'Whatsapp' 		=> 'ico-whatsapp',
	'Pinterest' 	=> 'ico-pinterest',
	'Yelp' 			=> 'ico-yelp',
	'Aim' 			=> 'ico-aim',
	'Gowalla' 		=> 'ico-gowalla',
	'Grooveshark' 	=> 'ico-grooveshark',
	'Mail' 			=> 'ico-mail',
	'Stumbleupon' 	=> 'ico-stumbleupon',
	'Pandora' 		=> 'ico-pandora',
	'Friendfeed' 	=> 'ico-friendfeed',
	'Instapaper' 	=> 'ico-instapaper'
);

/**
 * Set new shortcode map
 */

/* Banner Content */
vc_map( array(
   "name" 		=> __("Banner Content", "woothemes"),
   "base" 		=> "banner",
   "category" 	=> __('Content', "woothemes"),
   "icon" 		=> "icon-df_banner-image",
   "params" 	=> array(
		array(
		    "type" 		  => "attach_image",
		    "heading" 	  => __( "Image", "woothemes" ),
		    "param_name"  => "img",
		    "description" => __( "attach your banner image", "woothemes" )
	    ),
		array(
		    "type" 		  => "dropdown",
		    "heading" 	  => __( "Show Button ?", "woothemes" ),
		    "param_name"  => "button",
		    "value" 	  => array( "No" => "false","Yes" => "true" ),
		    "admin_label" => true
	    ),
		array(
		    "type" 		  => "textfield",
		    "heading" 	  => __( "URL Link Name", "woothemes" ),
		    "param_name"  => "link",
		    "value" 	  => "http://google.com",
		    "description" => __( "URL Name appear on text or button", "woothemes" ),
		    "dependency"  => array( 'element' => "button", 'value' => array( 'true' ) )
	    ),
	    array(
		    "type" 		  => "dropdown",
		    "heading" 	  => __("Target", "woothemes"),
		    "param_name"  => "target",
		    "dependency"  => array( 'element' => "button", 'value' => array( 'true' ) ),
		    "value" 	  => $target_arr
	    ),
		array(
		    "type" 		  => "textfield",
		    "heading" 	  => __( "Button Text", "woothemes" ),
		    "param_name"  => "button_text",
		    "value" 	  => "Click me !!",
		    "dependency"  => array( 'element' => "button", 'value' => array( 'true' ) )
	    ),
		array(
		    "type" 		  => "dropdown",
		    "heading" 	  => __( "Button Style", "woothemes" ),
		    "value" 	  => $button_style,
		    "param_name"  => "style",
		    "dependency"  => array( "element" => "button", "value" => array( "true" ) )
	    ),
		array(
		    "type" 		  => "colorpicker",
		    "heading" 	  => __( "Button Background Color ( Optional )", "woothemes" ),
		    "param_name"  => "color",
		    "dependency"  => array( "element" => "button", "value" => array( "true" ) )
	    ),
		array(
		    "type" 		  => "colorpicker",
		    "heading" 	  => __( "Button Text Color", "woothemes" ),
		    "param_name"  => "color_text",
		    "dependency"  => array( "element" => "button", "value" => array( "true" ) )
	    ),
		array(
		    "type" 		  => "dropdown",
		    "heading" 	  => __( "Banner Hovering?", "woothemes" ),
		    "param_name"  => "hover",
		    "value" 	  => array( "No" => "false", "Yes" => "true" ),
		    "admin_label" => true
	    ),
		array(
		    "type" 		  => "dropdown",
		    "heading" 	  => __( "Heading Size", "woothemes" ),
		    "param_name"  => "heading",
		    "value" 	  => array( "h1", "h2", "h3", "h4","h5", "h6" ),
		    "dependency"  => array( "element" => "hover", "value" => array( "true" ) ),
		    "admin_label" => true
	    ),
		array(
		    "type" 		  => "textfield",
		    "heading" 	  => __( "Banner Header text", "woothemes" ),
		    "param_name"  => "text",
		    "value" 	  => "My Heading",
		    "dependency"  => array( "element" => "hover", "value" => array( "true" ) ),
		    "admin_label" => true
	    ),
		array(
		    "type" 		  => "colorpicker",
		    "heading" 	  => __( "Banner Heading Text Color", "woothemes" ),
		    "value" 	  => "#FFFFFF",
		    "dependency"  => array( "element" => "hover", "value" => array( "true" ) ),
		    "param_name"  => "heading_color"
	    ),
		array(
		    "type" 		  => "colorpicker",
		    "heading" 	  => __( "Banner Border Color", "woothemes" ),
		    "value" 	  => "#FFFFFF",
		    "dependency"  => array( "element" => "hover", "value" => array( "true" ) ),
		    "param_name"  => "border_color",
	    ),
		array(
		    "type" 		  => "colorpicker",
		    "heading" 	  => __( "Insert RGBA Color", "woothemes" ),
		    "param_name"  => "rgba",
		    "dependency"  => array( "element" => "hover", "value" => array( "true" ) ),
		    "value" 	  => ""
	    )
	)
) );

/* Services */
vc_map( array(
    "name" 		=> __("Services Content", "woothemes"),
    "base" 		=> "our_services",
    "category" 	=> __('Content', "woothemes"),
    "icon" 		=> "icon-df_service",
    "params" 	=> array(
		array(
		   	"type" 		  => "textfield",
		   	"heading" 	  => __( "Title", "woothemes" ),
		   	"param_name"  => "title",
		   	"value" 	  => 'Title',
		   	"admin_label" => true
	   	),
		array(
		   	"type" 		  => "dropdown",
		   	"heading" 	  => __( "Version", "woothemes" ),
		   	"param_name"  => "version",
		   	"value" 	  => array( '1','2','3' ),
		   	"description" => __( "one, two, or three?", "woothemes" ),
		   	"admin_label" => true
	   	),
        array(
            "type" 		  => "textfield",
            "heading" 	  => __( "Services Icon", "woothemes" ),
            "param_name"  => "icon",
            "value" 	  => "fa fa-pencil",
            "description" => __( "insert font awesome class icon (font awesome cheatsheet click <a href='http://fortawesome.github.io/Font-Awesome/cheatsheet/' target='_blank'>here</a>)", "woothemes" )
        ),
        array(
           	"type" 		  => "textarea_html",
           	"holder" 	  => "div",
           	"heading" 	  => __( "Text", "woothemes" ),
           	"param_name"  => "content",
           	"value" 	  => "I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.",
           	"description" => __( "Enter your content.", "woothemes" )
        ),
		array(
		   	"type" 		  => "dropdown",
		   	"heading" 	  => __( "Text Position", "woothemes" ),
		   	"param_name"  => "align",
		   	"value" 	  => array(
		   	                    "Left" 	 => "left",
		   	                    "Center" => "center",
		   	                    "Right"  => "right"
		   	                 ),
		   	"description" => __( "Text Position", "woothemes" )
		),
		array(
		   	"type" 		  => "dropdown",
		   	"heading" 	  => __( "Show Button?", "woothemes" ),
		   	"param_name"  => "button",
		   	"value" 	  => array( "No" => "false", "Yes" => "true" )
	   	),
		array(
		   	"type" 		  => "dropdown",
		   	"heading" 	  => __( "Style", "woothemes" ),
		   	"param_name"  => "style",
		   	"value" 	  => array( "One" => "style1", "Two" => "style2" ),
		   	"description" => __( "Style", "woothemes" ),
		   	"dependency"  => array( "element" => "button", "value" => array( "true" ) )
	   	),
		array(
		   	"type" 		  => "dropdown",
		   	"heading" 	  => __( "Target Link", "woothemes" ),
		   	"param_name"  => "target",
		   	"value" 	  => $target_arr,
		   	"dependency"  => array( "element" => "button", "value" => array( "true" ) )
	   	),
		array(
		   	"type" 		  => "textfield",
		   	"heading" 	  => __( "Link Name", "woothemes" ),
		   	"param_name"  => "link_name",
		   	"value" 	  => "Button",
		   	"description" => __( "Link Name", "woothemes" ),
		   	"dependency"  => array( "element" => "button", "value" => array( "true" ) )
	   	),
		array(
		   	"type" 		  => "textfield",
		   	"heading" 	  => __( "URL", "woothemes" ),
		   	"param_name"  => "link_url",
		   	"value" 	  => "http://google.com",
		   	"description" => __( "URL", "woothemes" ),
		   	"dependency"  => array( "element" => "button", "value" => array( "true" ) )
		),
		array(
		   	"type" 		  => "colorpicker",
		   	"heading" 	  => __( "Link Color", "woothemes" ),
		   	"param_name"  => "link_color",
		   	"value" 	  => "",
		   	"description" => __( "Link Color", "woothemes" ),
		   	"dependency"  => array( "element" => "button", "value" => array( "true" ) )
	   	),
		array(
		   	"type" 		  => "colorpicker",
		   	"heading" 	  => __( "Border Color", "woothemes" ),
		   	"param_name"  => "border_color",
		   	"value" 	  => "#dbdbdb",
		   	"description" => __( "Border Color", "woothemes" ),
		   	"dependency"  => array( "element" => "button", "value" => array( "true" ) )
	   	),
		array(
		   	"type" 		  => "colorpicker",
		   	"heading" 	  => __( "Icon Color", "woothemes" ),
		   	"param_name"  => "icon_color",
		   	"value" 	  => "#dbdbdb",
		   	"description" => __( "Change your icon Color here", "woothemes" )
		),
		array(
		   	"type" 		  => "colorpicker",
		   	"heading" 	  => __( "Icon Color Background", "woothemes" ),
		   	"param_name"  => "icon_bg",
		   	"value" 	  => "#dbdbdb",
		   	"description" => __( "Change your background color (only apply to version 1 and 3)", "woothemes" )
		)
	)
) );

/* Services List */
vc_map( array(
    "name" 		=> __( "Services List Content", "woothemes" ),
    "base" 		=> "our_services_list",
    "category" 	=> __( "Content", "woothemes" ),
    "icon" 		=> "icon-df_service-list",
    "params" 	=> array(
		array(
			"type" 		  => "textfield",
			"heading" 	  => __( "Title", "woothemes" ),
			"param_name"  => "title",
			"value" 	  => "Title",
			"description" => __( "Enter Your Title", "woothemes" ),
			"admin_label" => true
		),
		array(
			"type" 		  => "textfield",
			"heading" 	  => __( "Services Icon", "woothemes" ),
			"param_name"  => "icon",
			"value" 	  => "fa fa-pencil",
			"description" => __( "insert font awesome class icon (font awesome cheatsheet click <a href='http://fortawesome.github.io/Font-Awesome/cheatsheet/' target='_blank'>here</a>)", "woothemes" )
		),
		array(
			"type" 		  => "textarea_html",
			"holder" 	  => "div",
			"heading" 	  => __( "Text", "woothemes" ),
			"param_name"  => "content",
			"value" 	  => "I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.",
			"description" => __( "Enter your content.", "woothemes" ),
			"admin_label" => true
		),
		array(
			"type" 		  => "colorpicker",
			"heading" 	  => __( "Icon And Title Color ", "woothemes" ),
			"param_name"  => "icon_color",
			"value" 	  => "#dbdbdb",
			"description" => __( "Change your background color (only apply to version 1 and 3)", "woothemes" ),
		)
	)
) );

/* Social Icon */
vc_map( array(
	"name" 		=> __("Social Icon", "woothemes"),
	"base" 		=> "social_icon",
	"category"  => __('Content', "woothemes"),
	"icon" 		=> "icon-df_social-icon",
	"params" 	=> array(
		array(
			"type" 		  => "dropdown",
			"heading" 	  => __( "Type of Icon", "woothemes" ),
			"param_name"  => "type",
			"value" 	  => $type_icon,
			"admin_label" => true
		),
		array(
			"type" 		  => "textfield",
			"heading" 	  => __( "Social URL", "woothemes" ),
			"param_name"  => "url"
		),
		array(
			"type" 		  => "dropdown",
			"heading" 	  => __( "Size of Icon", "woothemes" ),
			"param_name"  => "size",
			"value" 	  => array( "small", "medium", "big")
		),
		array(
			"type" 		  => "dropdown",
			"heading" 	  => __( "Target Link", "woothemes" ),
			"param_name"  => "target",
			"value" 	  => $target_arr
		),
		array(
			"type" 		  => "colorpicker",
			"heading" 	  => __( "Icon Color", "woothemes" ),
			"param_name"  => "color",
			"value" 	  => "#ffffff",
			"description" => __( "Icon Color", "woothemes" ),
			"admin_label" => true
		),
		array(
			"type" 		  => "colorpicker",
			"heading" 	  => __( "Background Icon Color", "woothemes" ),
			"param_name"  => "back",
			"value" 	  => "#000000",
			"description" => __( "Background Icon Color", "woothemes" ),
			"dependency"  => array( "element" => "size", "value" => array( "medium", "big" ) ),
			"admin_label" => true
		)
	)
) );

/* Teaser */
vc_map( array(
	"name" 		=> __("Teaser", "woothemes"),
	"base" 		=> "teaser",
	"category" 	=> __('Content', "woothemes"),
	"icon" 		=> "icon-df_teaser",
	"params" 	=> array(
		array(
			"type" 		  => "textfield",
			"heading" 	  => __( "Title", "woothemes" ),
			"param_name"  => "title",
			"value" 	  => "Title",
			"description" => __( "Enter Your Title", "woothemes" )
		),
		array(
			"type" 		  => "textarea_html",
			"holder" 	  => "div",
			"heading" 	  => __( "Text", "woothemes" ),
			"param_name"  => "content",
			"value" 	  => "I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.",
			"description" => __( "Enter your content.", "woothemes" )
		),
		array(
			"type" 		  => "attach_image",
			"heading" 	  => __( "Teaser Image", "woothemes" ),
			"param_name"  => "img",
			"value" 	  => ""
		),
		array(
			"type" 		  => "dropdown",
			"heading" 	  => __( "Show Button?", "woothemes" ),
			"param_name"  => "button",
			"value" 	  => array( "No" => "false", "Yes" => "true" )
		),
		array(
			"type" 		  => "dropdown",
			"heading" 	  => __( "Target Link", "woothemes" ),
			"param_name"  => "target",
			"value" 	  => $target_arr,
			"dependency"  => array( "element" => "button", "value" => array( "true" ) )
		),
		array(
			"type" 		  => "textfield",
			"heading" 	  => __( "Button Name", "woothemes" ),
			"param_name"  => "button_text",
			"value" 	  => "Button",
			"description" => __( "Link Name", "woothemes" ),
			"dependency"  => array( "element" => "button", "value" => array( "true" ) )
		),
		array(
			"type" 		  => "textfield",
			"heading" 	  => __( "Button URL", "woothemes" ),
			"param_name"  => "link",
			"value" 	  => "http://google.com",
			"description" => __( "URL", "woothemes" ),
			"dependency"  => array( "element" => "button", "value" => array( "true" ) )
		),
		array(
			"type" 	  	  => "dropdown",
			"heading" 	  => __( "Button Style", "woothemes" ),
			"param_name"  => "style",
			"value" 	  => $button_style,
			"dependency"  => array( "element" => "button", "value" => array( "true" ) )
		),
		array(
			"type" 		  => "colorpicker",
			"heading" 	  => __( "Button text Color", "woothemes" ),
			"param_name"  => "color_text",
			"value" 	  => "",
			"dependency"  => array( "element" => "button", "value" => array( "true" ) )
		),
		array(
			"type" 		  => "colorpicker",
			"heading" 	  => __( "Button Background Color", "woothemes" ),
			"param_name"  => "bgcolor",
			"value" 	  => "",
			"dependency"  => array( "element" => "button", "value" => array( "true" ) )
		)
	)
) );

/* Teaser Box */
vc_map( array(
	"name" 		=> __( "Teaser Box", "woothemes" ),
	"base" 		=> "teaserbox",
	"category"  => __( "Content", "woothemes" ),
	"icon" 		=> "icon-df_teaserbox",
	"params" 	=> array(
		array(
			"type" 		  => "textfield",
			"heading" 	  => __("Title", "woothemes"),
			"param_name"  => "title",
			"value" 	  => 'Title',
			"description" => __("Enter Your Title", "woothemes")
		),
		array(
			"type" 		  => "textarea_html",
			"holder" 	  => "div",
			"class" 	  => "",
			"heading" 	  => __("Text", "woothemes"),
			"param_name"  => "content",
			"value" 	  => "I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.",
			"description" => __("Enter your content.", "woothemes")
		),
		array(
			"type" 		  => "dropdown",
			"heading" 	  => __("Text Position", "woothemes"),
			"param_name"  => "align",
			"value" 	  => array('Center' => 'center','Left' => 'left','Right' => 'right'),
			"description" => __("Text Position", "woothemes")
		),
		array(
			"type" 		  => "dropdown",
			"heading" 	  => __("Use Image As Background", "woothemes"),
			"param_name"  => "back_image",
			"value" 	  => array( 'No' => 'false', 'Yes' => 'true' )
		),
		array(
			"type" 		  => "colorpicker",
			"heading" 	  => __("Background Color", "woothemes"),
			"param_name"  => "background_color",
			"dependency"  => array( "element" => "back_image", "value" => array( "false" ) ),
			"value" 	  => ''
		),
		array(
			"type" 		  => "attach_image",
			"heading" 	  => __("Teaser Image", "woothemes"),
			"param_name"  => "img",
			"dependency"  => array( "element" => "back_image", "value" => array( "true" ) ),
			"value" 	  => ""
		),
		array(
			"type" 		  => "colorpicker",
			"heading" 	  => __("Border Color", "woothemes"),
			"param_name"  => "border_color",
			"value" 	  => ''
		),
		array(
			"type" 		  => "colorpicker",
			"heading" 	  => __("Text Color", "woothemes"),
			"param_name"  => "text_color",
			"value" 	  => ''
		),
		array(
			"type" 		  => "dropdown",
			"heading" 	  => __("Show Button?", "woothemes"),
			"param_name"  => "button",
			"value" 	  => array( 'No' => 'false', 'Yes' => 'true' )
		),
		array(
			"type" 		  => "textfield",
			"heading"	  => __("Button Name", "woothemes"),
			"param_name"  => "button_text",
			"value" 	  => 'Button',
			"dependency"  => array( "element" => "button", "value" => array( "true" ) ),
			"description" => __("Link Name", "woothemes")
		),
		array(
			"type" 		  => "textfield",
			"heading" 	  => __("Button URL", "woothemes"),
			"param_name"  => "link",
			"value" 	  => 'http://google.com',
			"dependency"  => array( "element" => "button", "value" => array( "true" ) ),
			"description" => __("URL", "woothemes")
		),
		array(
			"type" 		  => "dropdown",
			"heading" 	  => __("Button Style", "woothemes"),
			"param_name"  => "style",
			"dependency"  => array( "element" => "button", "value" => array( "true" ) ),
			"value" 	  => $button_style,
		),
		array(
			"type" 		  => "colorpicker",
			"heading" 	  => __("Button text Color", "woothemes"),
			"param_name"  => "color_text",
			"dependency"  => array( "element" => "button", "value" => array( "true" ) ),
			"value" 	  => ''
		),
		array(
			"type" 		  => "colorpicker",
			"heading" 	  => __("Button Background Color", "woothemes"),
			"param_name"  => "bgcolor",
			"dependency"  => array( "element" => "button", "value" => array( "true" ) ),
			"value" 	  => ''
		),
		array(
			"type" 		  => "dropdown",
			"heading" 	  => __("Target", "woothemes"),
			"param_name"  => "target",
			"dependency"  => array( "element" => "button", "value" => array( "true" ) ),
			"value" 	  => $target_arr
		)
	)
) );

/* CallOut Action */
vc_map( array(
	"name" 		=> __("Callout Action", "woothemes"),
	"base" 		=> "callout",
	"category" 	=> __('Content', "woothemes"),
	"icon" 		=> "icon-df_call-to-action",
	"params" 	=> array(
		array(
			"type" 		  => "textfield",
			"heading" 	  => __("Title", "woothemes"),
			"param_name"  => "title",
			"value" 	  => 'Title',
			"description" => __("Enter Your Title", "woothemes")
		),
		array(
			"type" 		  => "colorpicker",
			"heading" 	  => __("Border Content Color", "woothemes"),
			"param_name"  => "border_color",
			"value" 	  => '#dbdbdb'
		),
		array(
			"type" 		  => "colorpicker",
			"heading" 	  => __("Background Content Color", "woothemes"),
			"param_name"  => "background_color",
			"value" 	  => '#dbdbdb'
		),
		array(
			"type" 	 	  => "textarea_html",
			"holder" 	  => "div",
			"class" 	  => "",
			"heading" 	  => __("Text", "woothemes"),
			"param_name"  => "content",
			"value" 	  => "Lorem ipsum dolor sit amet, consectetur adipisicing elit.",
			"description" => __("Enter your content.", "woothemes")
		),
		array(
			"type" 		  => "textfield",
			"heading" 	  => __("Button Name", "woothemes"),
			"param_name"  => "button_text",
			"value" 	  => 'Button',
			"description" => __("Link Name", "woothemes")
		),
		array(
			"type" 		  => "textfield",
			"heading" 	  => __("Button URL", "woothemes"),
			"param_name"  => "link",
			"value" 	  => 'http://google.com',
			"description" => __("URL", "woothemes")
		),
		array(
			"type" 		  => "dropdown",
			"heading" 	  => __("Target Link", "woothemes"),
			"param_name"  => "target",
			"value" 	  => $target_arr
		),
		array(
			"type" 		  => "dropdown",
			"heading" 	  => __("Button Style", "woothemes"),
			"param_name"  => "style",
			"value" 	  => $button_style,
		),
		array(
			"type" 		  => "colorpicker",
			"heading" 	  => __("Button text Color", "woothemes"),
			"param_name"  => "color_text",
			"value" 	  => ''
		),
		array(
			"type" 		  => "colorpicker",
			"heading" 	  => __("Button Background Color", "woothemes"),
			"param_name"  => "color",
			"value" 	  => ''
		),
		array(
			"type" 		  => "textfield",
			"heading" 	  => __("Button Position", "woothemes"),
			"param_name"  => "pos_x",
			"value" 	  => '40px',
			"description" => __("position of button from right margin", "woothemes")
		)
	)
) );

/* Box Content */
vc_map( array(
	"name" 		=> __("Box Content", "woothemes"),
	"base" 		=> "box",
	"category" 	=> __('Content', "woothemes"),
	"icon" 		=> "icon-df_box",
	"params" 	=> array(
		array(
			"type" 	 	 	=> "dropdown",
			"heading" 	 	=> __("Box Version", "woothemes"),
			"param_name" 	=> "ver",
			"admin_label"	=> true,
			"value" 	 	=> array('1', '2')
		),
		array(
			"type" 		 	=> "textarea_html",
			"heading" 	 	=> __("Content", "woothemes"),
			"param_name" 	=> "content",
			"admin_label"	=> true,
			"value" 	 	=> "Lorem ipsum dolor sit amet."
		),
		array(
			"type" 		 	=> "dropdown",
			"heading" 	 	=> __("Use Image As Background", "woothemes"),
			"param_name" 	=> "back_image",
			"value" 	 	=> array('No' => 'false', 'Yes' => 'true'),
			"admin_label"	=> true,
			"dependency" 	=> array('element' => "ver", 'value' => array('2'))
		),
		array(
			"type" 		 	=> "attach_image",
			"heading" 	 	=> __("Box Image", "woothemes"),
			"param_name" 	=> "img",
			"value" 	 	=> "",
			"admin_label"	=> true,
			"dependency" 	=> array('element' => "back_image", 'value' => array('true'))
		),
		array(
			"type" 		 	=> "colorpicker",
			"heading" 	 	=> __("Box Background", "woothemes"),
			"param_name" 	=> "back",
			"admin_label"	=> true,
			"value" 	 	=> "#000000",
			"dependency" 	=> array('element' => "back_image", 'value' => array('false'))
		),
		array(
			"type" 		 	=> "colorpicker",
			"heading" 	 	=> __("Border Color", "woothemes"),
			"param_name" 	=> "border_color",
			"admin_label"	=> true,
			"value" 	 	=> "#dbdbdb"
		),
		array(
			"type" 		 	=> "dropdown",
			"heading" 	 	=> __("Text Align", "woothemes"),
			"param_name" 	=> "align",
			"admin_label"	=> true,
			"value" 	 	=> array('center', 'left', 'right')
		),
		array(
			"type" 		 	=> "textfield",
			"heading" 	 	=> __("Button Name", "woothemes"),
			"param_name" 	=> "href_text",
			"value" 	 	=> 'Link',
			"description" 	=> __("Link Name", "woothemes"),
			"admin_label"	=> true,
			"dependency" 	=> array('element' => "ver", 'value' => array('2'))
		),
		array(
			"type" 		 	=> "textfield",
			"heading" 	 	=> __("Button URL", "woothemes"),
			"param_name" 	=> "href",
			"value" 	 	=> 'http://google.com',
			"description" 	=> __("URL", "woothemes"),
			"admin_label"	=> true,
			"dependency" 	=> array('element' => "ver", 'value' => array('2'))
		),
		array(
			"type" 		 	=> "dropdown",
			"heading" 	 	=> __("Target Link", "woothemes"),
			"param_name" 	=> "target",
			"value" 	 	=> $target_arr,
			"admin_label"	=> true,
			"dependency" 	=> array('element' => "ver", 'value' => array('2'))
		),
		array(
			"type" 		 	=> "colorpicker",
			"heading" 	 	=> __("Color text", "woothemes"),
			"param_name" 	=> "href_color",
			"value" 	 	=> "#fff",
			"admin_label"	=> true,
			"dependency" 	=> array('element' => "ver", 'value' => array('2'))
		)
	)
) );

/* Blog Grid */
vc_map( array(
	"name" 		=> __("Blogpost Grid", "woothemes"),
	"base" 		=> "blog",
	"category" 	=> __('Content', "woothemes"),
	"icon" 		=> "icon-df_blog-grid",
	"params" 	=> array(
		array(
			"type" 	 	 	=> "checkbox",
			"heading" 	 	=> __( "Show Title", "woothemes" ),
			"param_name" 	=> "show_title",
			"admin_label"	=> true,
			"value" 	 	=> array( __( "Allow", "woothemes" ) => 'yes' )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Title", "woothemes" ),
			"admin_label"	=> true,
			"param_name" 	=> "title",
			"dependency"	=> array( 'element' => 'show_title', 'value' => array( 'yes' ) ),
			"value" 		=> "Latest From The Blog"
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Column", "woothemes" ),
			"param_name" 	=> "col",
			"value" 		=> array( "2", "3", "4" ),
			"admin_label" 	=> true
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Number of Post to Display", "woothemes" ),
			"param_name" 	=> "posts",
			"admin_label" 	=> true,
			"value" 		=> "6"
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Categories", "woothemes" ),
			"param_name" 	=> "categories",
			"value" 		=> $link_category,
			"admin_label" 	=> true
		)
	)
) );

/* Blog list */
vc_map( array(
	"name" 		=> __("Blogpost List", "woothemes"),
	"base" 		=> "bloglist",
	"category" 	=> __('Content', "woothemes"),
	"icon" 		=> "icon-df_blog-list",
	"params" 	=> array(
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Version", "woothemes" ),
			"param_name" 	=> "version",
			"value" 		=> array( "1", "2" ),
			"admin_label" 	=> true
		),
		array(
			"type" 			=> "checkbox",
			"heading" 		=> __("Show Title", "woothemes"),
			"param_name" 	=> "show_title",
			"value" 		=> array( __("Allow", "woothemes") => 'yes' ),
			"admin_label" 	=> true
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Title", "woothemes" ),
			"param_name" 	=> "title",
			"value" 		=> "Latest Blog Entries",
			"admin_label" 	=> true,
			"dependency"	=> array( 'element' => 'show_title', 'value' => array( 'yes' ) )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Number of Post to Display", "woothemes" ),
			"param_name" 	=> "posts",
			"admin_label" 	=> true,
			"value" 		=> "4"
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Categories", "woothemes" ),
			"param_name" 	=> "categories",
			"value" 		=> $link_category,
			"admin_label" 	=> true
		)
	)
) );

/* Testimonial */
vc_map( array(
	"name" 		=> __("Testimonial", "woothemes"),
	"base" 		=> "testimonial",
	"category"  => __('Content', "woothemes"),
	"icon" 		=> "icon-df_testimonial",
	"params" 	=> array(
		array(
			"type" 		 	=> "dropdown",
			"heading" 	 	=> __( "Version", "woothemes" ),
			"param_name" 	=> "ver",
			"value" 		=> array( "1", "2", "3", "4", "5" ),
			"admin_label" 	=> true
		),
		array(
			"type" 			=> "textarea_html",
			"heading" 		=> __( "Enter Your Content", "woothemes" ),
			"param_name" 	=> "content",
			"value" 		=> "Lorem ipsum dolor sit amet.",
			"admin_label" 	=> true
		),
		array(
			"type" 			=> "attach_image",
			"heading" 		=> __( "Author Image", "woothemes" ),
			"param_name" 	=> "img",
			"value" 		=> "",
			"description" 	=> __( "Select images from media library.", "woothemes" ),
			"admin_label" 	=> true
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Name of Author", "woothemes" ),
			"param_name" 	=> "author",
			"value" 		=> "Jhon Doe",
			"admin_label" 	=> true
		)
	)
) );

/* Member */
vc_map( array(
   "name" 		=> __("Member", "woothemes"),
   "base" 		=> "member",
   "category" 	=> __('Content', "woothemes"),
   "icon" 		=> "icon-df_team-member",
   "params" 	=> array(
		array(
			"type" 			=> "attach_image",
			"heading" 		=> __( "Author Avatar", "woothemes" ),
			"param_name" 	=> "img",
			"admin_label"	=> true,
			"description" 	=> __( "Select images from media library.", "woothemes" )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Twitter URL", "woothemes" ),
			"param_name" 	=> "twitter",
			"admin_label"	=> true,
			"value" 		=> ""
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Facebook URL", "woothemes" ),
			"param_name" 	=> "facebook",
			"admin_label"	=> true,
			"value" 		=> ""
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Google+ URL", "woothemes" ),
			"param_name" 	=> "google",
			"admin_label"	=> true,
			"value" 		=> ""
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Tumblr URL", "woothemes" ),
			"param_name" 	=> "tumblr",
			"admin_label"	=> true,
			"value" 		=> ""
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Mailto", "woothemes" ),
			"param_name" 	=> "mail",
			"admin_label"	=> true,
			"value" 		=> ""
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Target", "woothemes" ),
			"param_name" 	=> "target",
			"admin_label"	=> true,
			"value" 		=> $target_arr,
		),
		array(
			"type" 			=> "colorpicker",
			"heading" 		=> __( "Background Color", "woothemes" ),
			"param_name" 	=> "back",
			"admin_label"	=> true,
			"value" 		=> "#000000"
		),
		array(
			"type" 			=> "colorpicker",
			"heading" 		=> __( "Icon Color", "woothemes" ),
			"param_name" 	=> "color",
			"admin_label"	=> true,
			"value" 		=> "#FFFFFF"
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Member Name", "woothemes" ),
			"param_name" 	=> "name",
			"value" 		=> "",
			"admin_label" 	=> true
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Member Role", "woothemes" ),
			"param_name" 	=> "role",
			"value" 		=> "",
			"admin_label" 	=> true
		),
		array(
			"type" 			=> "textarea_html",
			"heading" 		=> __( "Member Descriptions", "woothemes" ),
			"param_name" 	=> "content",
			"admin_label"	=> true,
			"value" 		=> "Lorem ipsum dolor sit amet.",
		)
	)
) );

/* Portfolio */
vc_map( array(
	"name" => __("Portfolio", "woothemes"),
	"base" => "portfolio",
	"category" => __('Content', "woothemes"),
	"icon" => "icon-df_portfolio",
	"params" => array(
		array(
			"type" => "textfield",
			"heading" => __("Post per page", "woothemes"),
			"param_name" => "post_per_page",
			"value" => '',
			"description" => __("How many post you want to show. (leave it blank if you want to show all post)", "woothemes"),
			"admin_label" => true
		),
		array(
			"type" => "dropdown",
			"heading" => __("Column", "woothemes"),
			"param_name" => "col",
			"value" => array(
				__("One column", "woothemes") => 'port-col-1',
				__("Two column", "woothemes") => 'port-col-2',
				__("Three column", "woothemes") => 'port-col-3',
				__("Four column", "woothemes") => 'port-col-4',
			),
			"admin_label" => true
		)
	)
) );

/* Parallax */
vc_map( array(
	"name" 		=> __("Parallax", "woothemes"),
	"base" 		=> "parallax",
	"category" 	=> __('Content', "woothemes"),
	"icon" 		=> "icon-df_parallax-image",
	"params" 	=> array(
		array(
			"type" 			=> "attach_image",
			"heading" 		=> __( "Background Image", "woothemes" ),
			"param_name" 	=> "img_bg",
			"admin_label"	=> true,
			"description" 	=> __( 'attach your background parallax image', 'woothemes' )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Unique Class", "woothemes" ),
			"param_name" 	=> "class",
			"admin_label"	=> true,
			"description" 	=> __( 'insert unique class of your background parallax image (required)', 'woothemes' )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Background Image Parallax Speed", "woothemes" ),
			"param_name" 	=> "speed",
			"value" 		=> '0.5',
			"admin_label" 	=> true
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Height", "woothemes" ),
			"param_name" 	=> "height",
			"description" 	=> __( 'Height of your background parallax image', 'woothemes' )
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Image Element", "woothemes" ),
			"param_name" 	=> "img_element",
			"value" 		=> array(
									__( 'No', "woothemes" ) => "no",
									__( 'Yes', "woothemes" ) => "yes",
							   ),
			"description" 	=> __( "Select if you'd like insert Parallax image element.", "woothemes" ),
			"admin_label" 	=> true
		),
		array(
			"type" 			=> "attach_image",
			"heading" 		=> __( "Element Of Image", "woothemes" ),
			"param_name" 	=> "img_el",
			"description" 	=> __( 'Attach your element parallax image this is not for background image', 'woothemes' ) ,
			"dependency" 	=> array( 'element' => "img_element", 'value' => array( 'yes' ) )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Unique Class Image Element", "woothemes" ),
			"param_name" 	=> "class_el",
			"description" 	=> __( 'Insert unique class of your background parallax image (required)', 'woothemes' ),
			"dependency" 	=> array( 'element' => "img_element", 'value' => array( 'yes' ) )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Top Position Image Element", "woothemes" ),
			"param_name" 	=> "top_img_el",
			"value" 		=> '0px',
			"description" 	=> __( 'eg 10px, 10em, 10% (value can also be a minus).', 'woothemes' ),
			"dependency"	=> array( 'element' => "img_element", 'value' => array( 'yes' ) )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Left Of Image Element", "woothemes" ),
			"param_name" 	=> "left_img_el",
			"value"		 	=> '0px',
			"dependency" 	=> array( 'element' => "img_element", 'value' => array( 'yes' ) )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Background Image Element Speed", "woothemes" ),
			"param_name" 	=> "speed_el",
			"value" 		=> '0.5',
			"admin_label" 	=> true,
			"dependency" 	=> array( 'element' => "img_element", 'value' => array( 'yes' ) )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Width of image element", "woothemes" ),
			"param_name" 	=> "width_el",
			"value" 		=> '980px',
			"dependency" 	=> array( 'element' => "img_element", 'value' => array( 'yes' ) )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Height of image element", "woothemes" ),
			"param_name" 	=> "height_el",
			"value" 		=> '0px',
			"dependency" 	=> array( 'element' => "img_element", 'value' => array( 'yes' ) )
		),
		array(
			"type" 			=> "textarea_html",
			"heading" 		=> __( "Content", "woothemes" ),
			"value" 		=> '',
			"param_name" 	=> "content",
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Content padding", "woothemes" ),
			"value" 		=> "20px",
			"param_name" 	=> "padding",
			"description" 	=> __( 'your padding can be in single value or you can specify eg: 20px 40px 20px 40px', 'woothemes' )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Content Width", "woothemes" ),
			"value" 		=> "100%",
			"param_name" 	=> "width"
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Content Position", "woothemes" ),
			"value" 		=> array( 'none','right','left' ),
			"param_name" 	=> 'float',
		)
	)
) );

/* advance google maps */
vc_map( array(
	"name" 		=> __("Advanced Google Maps", "woothemes"),
	"base" 		=> "advanced_gmaps",
	"category" 	=> __('Structure', 'woothemes'),
	"icon"     	=> "icon-df_googlemap",
	"params" 	=> array(
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Address 1 : Latitude", "woothemes" ),
			"param_name" 	=> "latitude",
			"value" 		=> "",
			"admin_label"	=> true,
			"description" 	=> __( 'Enter your Google Map coordinates to display a map on the Contact Form page template. You can get these details from <a href="http://itouchmap.com/latlong.html">Google Maps</a>', "woothemes" )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Address 1 : Longitude", "woothemes" ),
			"param_name" 	=> "longitude",
			"value" 		=> "",
			"admin_label"	=> true,
			"description" 	=> __( 'Enter your Google Map coordinates to display a map on the Contact Form page template. You can get these details from <a href="http://itouchmap.com/latlong.html">Google Maps</a>', "woothemes" )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Address 1 : Full Address Text (shown in tooltip)", "woothemes" ),
			"param_name" 	=> "address",
			"admin_label"	=> true,
			"value" 		=> ""
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Address 2 : Latitude", "woothemes" ),
			"param_name" 	=> "latitude_2",
			"value" 		=> "",
			"admin_label"	=> true,
			"description" 	=> __( 'Enter your Google Map coordinates to display a map on the Contact Form page template. You can get these details from <a href="http://itouchmap.com/latlong.html">Google Maps</a>', "woothemes" )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Address 2 : Longitude", "woothemes" ),
			"param_name" 	=> "longitude_2",
			"value" 		=> "",
			"admin_label"	=> true,
			"description"	=> __( 'Enter your Google Map coordinates to display a map on the Contact Form page template. You can get these details from <a href="http://itouchmap.com/latlong.html">Google Maps</a>', "woothemes" )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Address 2 : Full Address Text (shown in tooltip)", "woothemes" ),
			"param_name" 	=> "address_2",
			"admin_label"	=> true,
			"value" 		=> ""
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Address 3 : Latitude", "woothemes" ),
			"param_name" 	=> "latitude_3",
			"value" 		=> "",
			"admin_label"	=> true,
			"description" 	=> __( 'Enter your Google Map coordinates to display a map on the Contact Form page template. You can get these details from <a href="http://itouchmap.com/latlong.html">Google Maps</a>', "woothemes" )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Address 3 : Longitude", "woothemes" ),
			"param_name" 	=> "longitude_3",
			"value" 		=> "",
			"admin_label"	=> true,
			"description" 	=> __( 'Enter your Google Map coordinates to display a map on the Contact Form page template. You can get these details from <a href="http://itouchmap.com/latlong.html">Google Maps</a>', "woothemes" )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Address 3 : Full Address Text (shown in tooltip)", "woothemes" ),
			"param_name" 	=> "address_3",
			"admin_label"	=> true,
			"value" 		=> ""
		),
		array(
			"type" 			=> "attach_image",
			"heading" 		=> __( "Upload Marker Icon", "woothemes" ),
			"param_name" 	=> "img",
			"value" 		=> "",
			"admin_label"	=> true,
			"description" 	=> __( "If left blank Google Default marker will be used.", "woothemes" )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Map height", "woothemes" ),
			"param_name" 	=> "height",
			"admin_label"	=> true,
			"description" 	=> __( 'Enter map height in pixels. Example: 200).', "woothemes" )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Zoom", "woothemes" ),
			"param_name" 	=> "zoom",
			"admin_label"	=> true,
			"description" 	=> __( 'Insert number from 1 to 19', "woothemes" )
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __("Pan Control", "woothemes"),
			"param_name" 	=> "pan_control",
			"admin_label"	=> true,
			"value" 		=> array(
									__( "No", "woothemes" ) => "false",
									__( "Yes", "woothemes" ) => "true"
							   )
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Draggable", "woothemes" ),
			"param_name" 	=> "draggable",
			"admin_label"	=> true,
			"value" 		=> array(
									__("No", "woothemes") => "false",
									__("Yes", "woothemes") => "true"
							   )
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Zoom Control", "woothemes" ),
			"param_name" 	=> "zoom_control",
			"admin_label"	=> true,
			"value" 		=> array(
									__( "No", "woothemes" ) => "false",
									__( "Yes", "woothemes" ) => "true"
							   ),
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Map Type Control", "woothemes" ),
			"param_name" 	=> "map_type_control",
			"admin_label"	=> true,
			"value" 		=> array(
									__( "No", "woothemes" ) => "false",
									__( "Yes", "woothemes" ) => "true"
							   ),
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Scale Control", "woothemes" ),
			"param_name" 	=> "scale_control",
			"admin_label"	=> true,
			"value" 		=> array(
									__( "No", "woothemes" ) => "false",
									__( "Yes", "woothemes" ) => "true"
							   )
		),
		array(
			"type" 			=> "dropdown",
			"heading" 		=> __( "Modify Google Maps Hue, Saturation, Lightness", "woothemes" ),
			"param_name" 	=> "modify_coloring",
			"admin_label"	=> true,
			"value" 		=> array(
									__( "No", "woothemes" ) => "false",
									__( "Yes", "woothemes" ) => "true"
							   )
		),
		array(
			"type" 			=> "colorpicker",
			"heading" 		=> __( "Hue", "woothemes" ),
			"param_name" 	=> "hue",
			"description" 	=> __( "Sets the hue of the feature to match the hue of the color supplied. Note that the saturation and lightness of the feature is conserved, which means, the feature will not perfectly match the color supplied .", "woothemes" ),
			"admin_label"	=> true,
			"dependency" 	=> array( 'element' => "modify_coloring", 'value' => array( 'true' ) )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Saturation", "woothemes" ),
			"param_name" 	=> "saturation",
			"admin_label"	=> true,
			"description" 	=> __( 'Shifts the saturation of colors by a percentage of the original value if decreasing and a percentage of the remaining value if increasing. Valid values: [-100, 100].', "woothemes" ),
			"dependency" 	=> array( 'element' => "modify_coloring", 'value' => array( 'true' ) )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __("Lightness", "woothemes"),
			"param_name" 	=> "lightness",
			"description" 	=> __('Shifts lightness of colors by a percentage of the original value if decreasing and a percentage of the remaining value if increasing. Valid values: [-100, 100].', "woothemes"),
			"admin_label"	=> true,
			"dependency" 	=> array( 'element' => "modify_coloring", 'value' => array( 'true' ) )
		),
		array(
			"type" 			=> "textfield",
			"heading" 		=> __( "Extra class name", "woothemes" ),
			"param_name" 	=> "el_class",
			"value" 		=> "",
			"admin_label"	=> true,
			"description" 	=> __( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "woothemes" )
		)
	)
) );

/** -------------------------- WooCommerce -------------------------------- **/

if ( is_woocommerce_activated() ) :

	// Credit Card Icon
	vc_map( array(
		'name' 		=> _x( 'Credit Card', 'backend vc', 'woothemes' ),
		'base' 		=> 'credit',
		'class' 	=> '',
		'category' 	=> __( 'Content', 'woothemes' ),
		'icon' 		=> 'icon-df_credit-card',
		'params' 	=> array(
			array(
				'type' 		  => 'textfield',
				'holder' 	  => 'span',
				'class' 	  => '',
				'heading' 	  => __( 'Text', 'woothemes' ),
				'param_name'  => 'cards',
				'value' 	  => __( 'paypal,visa,mastercard,amex,cirrus,maestro,solo,discover,delta,visa-electron,bank-check', 'woothemes' ),
				'description' => __( 'The Credit cards with separator \',\' (paypal,visa,mastercard,amex,cirrus,maestro,solo,discover,delta,visa-electron,bank-check)', 'woothemes' )
			)
		)
	) );

	// Shop Carousel
	vc_map( array(
		'name' 		=> _x( 'Products', 'backend vc' ,'woothemes' ),
		'base' 		=> 'product_slider',
		'class' 	=> '',
		'category' 	=> __( 'Content', 'woothemes' ),
		'icon' 		=> 'icon-df_shop-product',
		'params' 	=> array(
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> __( 'Column Width', 'woothemes' ),
				'param_name' 	=> 'widths',
				'value' 		=> array(
					'1/1' => '1/1',
					'2/3' => '2/3',
					'1/2' => '1/2',
					'1/4' => '1/4'
				),
				'description' 	=> __( 'This Column it must be the same with row column you create', 'woothemes' ),
				'admin_label' 	=> true
			),
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> __( 'Product Type', 'woothemes' ),
				'param_name' 	=> 'product_type',
				'value' 		=> array(
					__( 'Best Sellers', 'woothemes' ) 	   => 'best-sellers',
					__( 'Latest Products', 'woothemes' )   => 'latest-products',
					__( 'Top Rated', 'woothemes' ) 		   => 'top-rated',
					__( 'Sale Products', 'woothemes' ) 	   => 'sale-products',
					__( 'Recently Viewed', 'woothemes' )   => 'recently-viewed',
					__( 'Featured Products', 'woothemes' ) => 'featured-products',
					__( 'SKUs/IDs', 'woothemes' ) 		   => 'sku-id'
				),
				'description' 	=> __( 'Select the order of products you\'d like to show.', 'woothemes' ),
				'admin_label' 	=> true
			),
			array(
				'type' 			=> 'dropdown',
				'heading' 		=> __( 'Carousel', 'woothemes' ),
				'param_name' 	=> 'carousel',
				'value' 		=> array(
					__( 'No', 'woothemes' )  => 'no',
					__( 'Yes', 'woothemes' ) => 'yes',
				),
				'description' 	=> __( 'Select if you\'d like the asset to be a carousel.', 'woothemes' ),
				'admin_label' 	=> true
			),
			array(
				'type' 			=> 'textfield',
				'class' 		=> '',
				'heading' 		=> __( 'Number of items', 'woothemes' ),
				'param_name' 	=> 'item_perpage',
				'value' 		=> '12',
				'description' 	=> __( 'The number of products to show.', 'woothemes' ),
				'admin_label' 	=> true
			),
			array(
				"type" 			=> "textfield",
				"class" 		=> "",
				"heading" 		=> __("Number of your product ID's", "woothemes"),
				"param_name" 	=> "ids",
				"value" 		=> "",
				"description" 	=> __("Multiple Products ID with separator \",\" (100,200,300) ", "woothemes"),
				"admin_label" 	=> true,
				"dependency" 	=> array('element' => "product_type", 'value' => array('sku-id'))
			),
			array(
				"type" 			=> "textfield",
				"class" 		=> "",
				"heading" 		=> __("Number of your product SKU's", "woothemes"),
				"param_name" 	=> "skus",
				"value" 		=> "",
				"description" 	=> __("Multiple Products SKU with separator \",\" (ABC,DEF,GHI) ", "woothemes"),
				"admin_label" 	=> true,
				"dependency" 	=> array('element' => "product_type", 'value' => array('sku-id'))
			)
		)
	) );

endif;